
******************************************************************
*
* PANEL-ANALYSIS (using an artificial dataset)
*
* JOSEF BRÜDERL, UNIVERSITY OF MUNICH, March 2019
*
******************************************************************

* This DO-File contains the STATA commands for the section on
* within analysis with age/period effects

* These are the variables in the dataset:
* id    person identifier
* time  # panel wave
* marr  marriage dummy (1=married)


*************************************
** Preliminaries    *****************
*************************************
clear 
set more off

* Load data
cd  "C:\Users\bruederl\LRZ Sync+Share\Vorlesung PDA\Stata Beispiele\Artificial Data\"    //Adapt this path!
use "Wage Premium 2.dta", clear


******************************************
* LINEAR AGE EFFECT ONLY
******************************************
gen marr=0                                              // Treatment
replace marr=1  if id==3 & time>3
replace marr=1  if id==4 & time>3
gen wage=0                                              // Outcome
replace wage = -1000 + age*100 + marr*500  if id==1
replace wage =         age*100 + marr*500  if id==2
replace wage = 1000  + age*100 + marr*500  if id==3
replace wage = 2000  + age*100 + marr*500  if id==4


* Plotting the data
twoway  (scatter wage age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage age if marr==1, c(L)),                             ///
        legend(label(1 "before marriage") label(2 "after marriage") pos(6) ring(0))

		
* Data preparation
gen   treat     = id   >= 3
		

* Panel Analysis
xtset id time

xtreg wage marr                 , fe     // without age effect
xtreg wage marr age             , fe     // correctly specified
xtreg wage marr age if treat==1 , fe     // without control group

reg wage marr age ibn.id, noconstant     // LSDV


* Including the counterfactual wage trend
twoway  (scatter wage age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                       ///
        (scatter wage age if marr==1, c(L))                              ///
		(function y=-1000 + 100*x, range(20 26) lcolor(blue) lpattern(dash))          ///
		(function y=        100*x, range(24 29) lcolor(blue) lpattern(dash))          ///
		(function y=1000  + 100*x, range(23 27) lcolor(blue) lpattern(dash))          ///
		(function y=2000  + 100*x, range(21 27) lcolor(blue) lpattern(dash)),          ///
        legend(order(3 "counterfactual wage profile") pos(5) ring(0))

		
******************************************
* + PERIOD EFFECT
******************************************
gen   shock = time>=4           // the period variable
gen   wage1 = wage + shock*300  // wage increase at t=3.5


* Plotting the data
twoway  (scatter wage1 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                        ///
        (scatter wage1 age if marr==1, c(L)),                             ///
        legend(off)

		
xtreg wage1 marr age                   , fe     // without period effect
xtreg wage1 marr age shock             , fe     // correctly specified
xtreg wage1 marr age shock if treat==1 , fe     // without control group

xtreg wage1 marr i.time, fe                     // two-way FE


reg wage1 marr age ibn.id, noconstant
* Including the conterfactual wage trend (mis-specified: without period effect)
twoway  (scatter wage1 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                        ///
        (scatter wage1 age if marr==1, c(L))                              ///
		(function y=-2129 + 157*x, range(20 26) lcolor(blue) lpattern(dash))          ///
		(function y=-1348 + 157*x, range(24 29) lcolor(blue) lpattern(dash))          ///
		(function y= -344 + 157*x, range(23 27) lcolor(blue) lpattern(dash))          ///
		(function y=  743 + 157*x, range(21 27) lcolor(blue) lpattern(dash)),          ///
        legend(order(3 "counterfactual wage profile") pos(5) ring(0))

* Including the counterfactual wage trend (correct model)
twoway  (scatter wage1 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                        ///
        (scatter wage1 age if marr==1, c(L))                              ///
		(function y=-1000 + 100*x, range(20 22) lcolor(blue) lpattern(dash))          ///
		(function y=        100*x, range(24 26) lcolor(blue) lpattern(dash))          ///
		(function y=1000  + 100*x, range(23 25) lcolor(blue) lpattern(dash))          ///
		(function y=2000  + 100*x, range(21 23) lcolor(blue) lpattern(dash))          ///
		(function y=-700  + 100*x, range(23 26) lcolor(blue) lpattern(dash))          ///
		(function y=300   + 100*x, range(27 29) lcolor(blue) lpattern(dash))          ///
		(function y=1300  + 100*x, range(26 27) lcolor(blue) lpattern(dash))          ///
		(function y=2300  + 100*x, range(24 27) lcolor(blue) lpattern(dash)),          ///
        legend(order(3 "counterfactual wage profile") pos(5) ring(0))


		
******************************************
* AGE EFFECT QUADRATIC + PERIOD EFFECT
******************************************
gen wage2=0
replace wage2 = -11000 + age*1000 - 20*age*age + marr*500  if id==1
replace wage2 = -10000 + age*1000 - 20*age*age + marr*500  if id==2
replace wage2 =  -9000 + age*1000 - 20*age*age + marr*500  if id==3
replace wage2 =  -8000 + age*1000 - 20*age*age + marr*500  if id==4

replace   wage2 = wage2 + shock*300  // wage increase at t=3.5

* Plotting the data
twoway  (scatter wage2 age, ylabel(0(1000)6000, grid angle(0))            ///
                 ymtick(500(1000)5500, grid) c(L))                        ///
        (scatter wage2 age if marr==1, c(L)),   legend(off)
		
xtreg wage2 marr c.age##c.age                   , fe     // without period effect
xtreg wage2 marr c.age##c.age shock             , fe     // correctly specified
xtreg wage2 marr c.age##c.age shock if treat==1 , fe     // without control group

xtreg wage2 marr i.time, fe    // now two-way FE is also biased!!

